"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CameraBadgeLeaderboard = void 0;
const LeaderboardConstants_1 = require("./Interfaces/LeaderboardConstants");
const ComponentUtils_1 = require("./ComponentUtils");
class CameraBadgeLeaderboard {
    constructor(scriptComponent, singleBadgePrefab, renderOrder) {
        this.screenTransform = null;
        this.simpleLeaderboardControl = null;
        this.simpleLeaderboard = null;
        this.animationTween = null;
        this.simpleLeaderboard = singleBadgePrefab.instantiate(scriptComponent.getSceneObject().getParent());
        this.simpleLeaderboard.enabled = true;
        this.simpleLeaderboardControl = this.simpleLeaderboard.getComponent("ScriptComponent");
        this.screenTransform = this.simpleLeaderboardControl.getParentScreenTransform();
        this.screenTransform.anchors.setCenter(LeaderboardConstants_1.LeaderboardConstants.SingleBadge.POSITION_OUT_OF_SCREEN);
        (0, ComponentUtils_1.setRenderOrderRecursivelyRelativeToParent)(scriptComponent.getSceneObject(), renderOrder);
        (0, ComponentUtils_1.setRenderLayerRecursively)(this.simpleLeaderboard, scriptComponent.getSceneObject().layer);
    }
    visualiseEntries(otherRecords, currentUserRecord) {
        if (!isNull(currentUserRecord)) {
            this.simpleLeaderboardControl.setUserRecord(currentUserRecord);
        }
    }
    setBitmoji(bitmojiTexture) {
        this.simpleLeaderboardControl.setBitmoji(bitmojiTexture);
    }
    show() {
        this.animateLeaderboard(true);
    }
    hide() {
        this.animateLeaderboard(false);
    }
    animateLeaderboard(toShow) {
        const startPos = this.screenTransform.anchors.getCenter();
        const endPos = toShow ? LeaderboardConstants_1.LeaderboardConstants.SingleBadge.POSITION : LeaderboardConstants_1.LeaderboardConstants.SingleBadge.POSITION_OUT_OF_SCREEN;
        const duration = startPos.distance(endPos) * LeaderboardConstants_1.LeaderboardConstants.SingleBadge.ANIMATION_DURATION_MS / 2;
        if (duration === 0) {
            return;
        }
        if (!isNull(this.animationTween)) {
            try {
                this.animationTween.stop();
                TWEEN.remove(this.animationTween);
            }
            catch (e) { }
        }
        this.animationTween = new TWEEN.Tween({ x: startPos.x, y: startPos.y })
            .to({ x: endPos.x, y: endPos.y }, duration)
            .onUpdate((obj) => {
            this.screenTransform.anchors.setCenter(new vec2(obj.x, obj.y));
        })
            .easing(TWEEN.Easing.Quadratic.InOut);
        this.animationTween.start();
    }
}
exports.CameraBadgeLeaderboard = CameraBadgeLeaderboard;
//# sourceMappingURL=CameraBadgeLeaderboard.js.map